<?php
session_start();

// Load configuration
$config = json_decode(file_get_contents('config.json'), true);

// Function to generate a random alphanumeric string for CAPTCHA
function generateCaptcha() {
    return substr(str_shuffle("0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ"), 0, 6);
}

// Generate and store the CAPTCHA in the session
if (!isset($_SESSION['captcha'])) {
    $_SESSION['captcha'] = generateCaptcha();
}

// Function to check if the user has exceeded the search limit
function canPerformSearch() {
    if (!isset($_SESSION['search_attempts'])) {
        $_SESSION['search_attempts'] = [];
    }

    // Remove attempts older than 10 minutes
    $now = time();
    $_SESSION['search_attempts'] = array_filter($_SESSION['search_attempts'], function ($timestamp) use ($now) {
        return ($now - $timestamp) < 600; // 600 seconds = 10 minutes
    });

    // Check if the user has made 2 or more attempts in the last 10 minutes
    return count($_SESSION['search_attempts']) < 4;
}

// Function to record a search attempt
function recordSearchAttempt() {
    $_SESSION['search_attempts'][] = time();
}

$resultHTML = ""; // Initialize a variable to store the result HTML

if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['submit'])) {
    if (canPerformSearch()) {
        $rollNumber = trim($_POST['rollno']);
        $captcha = trim($_POST['captcha']);

        if ($captcha !== $_SESSION['captcha']) {
            $resultHTML = "<div class='alert'>Invalid CAPTCHA. Please try again.</div>";
        } else {
            // Validate roll number range
            $rollNumberInt = intval($rollNumber);
            if ($rollNumberInt < $config['roll_number_min'] || $rollNumberInt > $config['roll_number_max']) {
                $resultHTML = "<div class='alert'>Please enter a valid roll number between " . $config['roll_number_min'] . " and " . $config['roll_number_max'] . ".</div>";
            } else {
                // Database connection parameters
                $servername = "localhost";
                $username = "resultsa_kami2k";
                $password = "X{V4rZc+uuj1";
                $dbname = "resultsa_results";

                // Create connection
                $conn = new mysqli($servername, $username, $password, $dbname);

                // Check connection
                if ($conn->connect_error) {
                    die("<div class='alert'>Connection failed: " . $conn->connect_error . "</div>");
                }

                // Prepare and bind
                $stmt = $conn->prepare("SELECT rollno, regno, name, fname, result, remarks, chance FROM " . $config['table_name'] . " WHERE rollno = ?");
                $stmt->bind_param("s", $rollNumber);

                // Execute statement
                $stmt->execute();
                $stmt->bind_result($rollno, $regno, $name, $fname, $result, $remarks, $chance);

                // Fetch result
                if ($stmt->fetch()) {
                    $resultClass = ($result == "Fail") ? "fail" : "pass";
                    $resultHTML = "<div class='card'>";
                    $resultHTML .= "<center><h4>Student Result For Roll Number: $rollNumber</h4></center>";
                    $resultHTML .= "<div class='field'><span class='label'>Roll Number:</span> <span class='data'>$rollno</span></div>";
                    $resultHTML .= "<div class='field'><span class='label'>Name:</span> <span class='data'>$name</span></div>";
                    $resultHTML .= "<div class='field'><span class='label'>Registration Number:</span> <span class='data'>$regno</span></div>";
                    $resultHTML .= "<div class='field'><span class='label'>Father's Name:</span> <span class='data'>$fname</span></div>";
                    if (!empty($remarks)) {
                        $resultHTML .= "<div class='field'><span class='label'>Remarks:</span> <span class='data'>$remarks</span></div>";
                    }
                    if (!empty($chance)) {
                        $resultHTML .= "<div class='field'><span class='label'>Chance:</span> <span class='data'>$chance</span></div>";
                    }
                    $resultHTML .= "<div class='result $resultClass'><strong>Result:</strong> $result</div>";
                    $resultHTML .= "</div>";
                } else {
                    $resultHTML = "<div class='alert'>No record found for Roll Number: $rollNumber</div>";
                }

                // Close connections
                $stmt->close();
                $conn->close();

                // Record this search attempt
                recordSearchAttempt();
            }
        }

        // Regenerate CAPTCHA for the next request
        $_SESSION['captcha'] = generateCaptcha();
    } else {
        $resultHTML = "<div class='alert'>You have reached the maximum number of searches allowed in 10 minutes. Please try again later.</div>";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $config['header_text']; ?></title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
            background-color: #f0f0;
        }
        .container {
            max-width: 600px;
            margin: 50px auto;
            padding: 20px;
            background-color: #fff;
            border-radius: 5px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        h1 {
            margin-bottom: 20px;
            font-size: 22px;
            text-align: center;
        }
        .form-group {
            margin-bottom: 15px;
        }
        .form-group label {
            display: block;
            margin-bottom: 5px;
            font-size: 12px;
        }
        .form-group input {
            border: none;
            font-size: 14px;
            line-height: 14px;
            width: 100%;
            padding: 8px;
            box-sizing: border-box;
            background-color: #FFFFE0;
        }
        .btn {
            display: block;
            width: 100%;
            padding: 10px;
            background-color: #007bff;
            color: #fff;
            border: none;
            border-radius: 5px;
            cursor: pointer;
        }
        .btn:hover {
            background-color: #0056b3;
        }
        .card {
            margin-top: 20px;
            padding: 20px;
            background-color: #e3f2fd;
            border-radius: 5px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        .field {
            display: flex;
            justify-content: flex-start;
            margin-bottom: 5px;
            border-bottom: 1px solid #fff;
            padding: 5px 0;
        }
        .field:last-child {
            border-bottom: none;
        }
        .label {
            width: 150px; /* Adjust the width as needed */
            font-weight: bold;
        }
        .data {
            flex-grow: 1;
        }
        .result {
            text-align: center;
            font-weight: bold;
            margin-top: 20px;
            padding: 10px;
            border-radius: 5px;
        }
        .fail {
            background-color: #f8d7da;
            color: #721c24;
        }
        .pass {
            background-color: #d4edda;
            color: #155724;
        }
        .alert {
            margin-top: 20px;
            padding: 20px;
            background-color: #f8d7da;
            border-radius: 5px;
            color: #721c24;
        }
        .captcha {
            font-weight: bold;
            font-size: 16px;
            background-color: #E3f2fd;
            padding: 5px;
            border-radius: 3px;
            text-align: center;
            user-select: none;
        }
        .header {
            display: flex;
            align-items: center;
            padding: 10px 20px;
            background-color: #0091E0;
            color: #fff;
        }
        .header img {
            height: 40px;
            margin-right: 20px;
        }
        .header h1 {
            margin: 0;
            font-size: 24px;
        }
    </style>
    <script>
        function validateForm() {
            var rollNumber = document.getElementById("rollno").value;
            var rollNumberInt = parseInt(rollNumber);
            if (isNaN(rollNumberInt) || rollNumberInt < <?php echo $config['roll_number_min']; ?> || rollNumberInt > <?php echo $config['roll_number_max']; ?>) {
                alert("Please enter a valid roll number between <?php echo $config['roll_number_min']; ?> and <?php echo $config['roll_number_max']; ?>.");
                return false;
            }
            return true;
        }
    </script>
</head>
<body>
    <div class="header">
        <img src="logo2.png" alt="Logo">
        <h3><?php echo $config['header_text']; ?></h3>
    </div>
    <div class="container">
        <form method="post" onsubmit="return validateForm()">
            <div class="form-group">
                <center><h4>Enter Your Roll Number As Written on The Answer Book</h4></center>
                <hr>
                <br>
                <label for="rollno">Enter Roll Number:</label>
                <input type="text" id="rollno" name="rollno" required pattern="\d+">
            </div>
            <div class="form-group">
                <label for="captcha">Enter CAPTCHA:</label>
                <div class='captcha'><?php echo $_SESSION['captcha']; ?></div>
                <br>
                <input type="text" id="captcha" name="captcha" required>
            </div>
            <button type="submit" name="submit" class="btn">Search Roll Number</button>
        </form>
        
        <?php
        // Output the result HTML after the form
        echo $resultHTML;
        ?>
    </div>
</body>
</html>
