<?php
// fix_permissions.php
$configFile = __DIR__ . '/config.json';

// Check if file exists, if not create it
if (!file_exists($configFile)) {
    file_put_contents($configFile, "{}");
    echo "config.json created.<br>";
}

// Try to set permissions
if (@chmod($configFile, 0666)) {
    echo "✅ Permissions for config.json set to 666 (read/write for all).<br>";
} else {
    echo "❌ Failed to set permissions. You may need to do it manually via SSH or cPanel.<br>";
}

// Check if writable
if (is_writable($configFile)) {
    echo "✅ config.json is now writable.<br>";
} else {
    echo "❌ config.json is still not writable.<br>";
}
