<?php
session_start();

// Enable error reporting for debugging
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Redirect to login if not logged in
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header("Location: admin_login.php");
    exit();
}

// Database connection parameters
$servername = "localhost";
$username = "resultsa_kami2k";
$password = "X{V4rZc+uuj1";
$dbname = "resultsa_results";

// Create connection
$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Fetch list of tables
$tables = [];
$result = $conn->query("SHOW TABLES");
while ($row = $result->fetch_array()) {
    $tables[] = $row[0];
}

// Path to config file
$configFile = 'config.json';

// Load existing configuration
$config = @json_decode(file_get_contents($configFile), true);
if ($config === null && json_last_error() !== JSON_ERROR_NONE) {
    // Handle JSON decoding error
    echo "<div style='color:red;'>Error decoding config.json: " . json_last_error_msg() . "</div>";
    $config = []; // Initialize an empty array to avoid further errors
} elseif ($config === false) {
    // Handle file_get_contents failure (e.g., file not found or permissions)
    echo "<div style='color:red;'>Error reading config.json. Please ensure the file exists and is readable.</div>";
    $config = []; // Initialize an empty array
}

// Handle form submission
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $config['table_name'] = trim($_POST['table_name']);
    $config['header_text'] = trim($_POST['header_text']);
    $config['roll_number_min'] = intval($_POST['roll_number_min']);
    $config['roll_number_max'] = intval($_POST['roll_number_max']);

    if (is_writable($configFile)) {
    if (file_put_contents($configFile, json_encode($config, JSON_PRETTY_PRINT))) {
        $message = "Configuration updated successfully!";
    } else {
        $message = "<div style='color:red;'>Unable to write to config.json. Try checking disk space or file locks.</div>";
    }
} else {
    $message = "<div style='color:red;'>config.json is not writable. Please fix permissions.</div>";
}

}

// Fetch first 10 rows and total row count from selected table
$selectedTable = isset($config['table_name']) ? $config['table_name'] : '';
$first10Rows = [];
$totalRows = 0;

if (!empty($selectedTable)) {
    $result = $conn->query("SELECT * FROM `$selectedTable` LIMIT 10");
    while ($row = $result->fetch_assoc()) {
        $first10Rows[] = $row;
    }

    $result = $conn->query("SELECT COUNT(*) as total FROM `$selectedTable`");
    $totalRows = $result->fetch_assoc()['total'];
}

$conn->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
            background-color: #f8f9fa;
        }
        .container {
            max-width: 800px;
            margin: 50px auto;
            padding: 20px;
            background-color: #fff;
            border-radius: 5px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        h1 {
            margin-bottom: 20px;
            font-size: 22px;
            text-align: center;
        }
        .form-group {
            margin-bottom: 15px;
        }
        .form-group label {
            display: block;
            margin-bottom: 5px;
            font-size: 14px;
        }
        .form-group input,
        .form-group select {
            width: 100%;
            padding: 8px;
            box-sizing: border-box;
            font-size: 14px;
        }
        .btn {
            display: block;
            width: 100%;
            padding: 10px;
            background-color: #007bff;
            color: #fff;
            border: none;
            border-radius: 5px;
            cursor: pointer;
        }
        .btn:hover {
            background-color: #0056b3;
        }
        .message {
            margin-top: 20px;
            padding: 10px;
            background-color: #d4edda;
            border: 1px solid #c3e6cb;
            color: #155724;
            border-radius: 5px;
        }
        .table-container {
            margin-top: 30px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        table, th, td {
            border: 1px solid #ddd;
        }
        th, td {
            padding: 8px;
            text-align: left;
        }
        th {
            background-color: #f2f2f2;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>Admin Dashboard</h1>
        <?php if (isset($message)) echo "<div class='message'>$message</div>"; ?>
        <form method="post" action="">
            <div class="form-group">
                <label for="table_name">Table Name:</label>
                <select id="table_name" name="table_name" required>
                    <?php
                    foreach ($tables as $table) {
                        $selected = (isset($config['table_name']) && $table === $config['table_name']) ? "selected" : "";
                        echo "<option value=\"$table\" $selected>$table</option>";
                    }
                    ?>
                </select>
            </div>
            <div class="form-group">
                <label for="header_text">Header Text:</label>
                <input type="text" id="header_text" name="header_text" value="<?php echo isset($config['header_text']) ? htmlspecialchars($config['header_text']) : ''; ?>" required>
            </div>
            <div class="form-group">
                <label for="roll_number_min">Roll Number Min:</label>
                <input type="number" id="roll_number_min" name="roll_number_min" value="<?php echo isset($config['roll_number_min']) ? htmlspecialchars($config['roll_number_min']) : ''; ?>" required>
            </div>
            <div class="form-group">
                <label for="roll_number_max">Roll Number Max:</label>
                <input type="number" id="roll_number_max" name="roll_number_max" value="<?php echo isset($config['roll_number_max']) ? htmlspecialchars($config['roll_number_max']) : ''; ?>" required>
            </div>
            <button type="submit" class="btn">Save Changes</button>
        </form>
        <div class="table-container">
            <h2>Table: <?php echo htmlspecialchars($selectedTable); ?></h2>
            <p>Total Rows: <?php echo $totalRows; ?></p>
            <table>
                <thead>
                    <tr>
                        <?php
                        if (!empty($first10Rows) && is_array($first10Rows)) {
                            foreach (array_keys($first10Rows[0]) as $column) {
                                echo "<th>" . htmlspecialchars($column) . "</th>";
                            }
                        }
                        ?>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    if (is_array($first10Rows)) {
                        foreach ($first10Rows as $row) {
                            echo "<tr>";
                            foreach ($row as $value) {
                                echo "<td>" . htmlspecialchars($value) . "</td>";
                            }
                            echo "</tr>";
                        }
                    }
                    ?>
                </tbody>
            </table>
        </div>
    </div>
</body>
</html>