<?php
session_start();

// Check if admin is logged in
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header('Location: admin_login.php');
    exit;
}

// Load configuration
$config = json_decode(file_get_contents('config.json'), true);

// Save changes
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['save'])) {
    $config['table_name'] = $_POST['table_name'];
    $config['header_text'] = $_POST['header_text'];
    file_put_contents('config.json', json_encode($config));
    $message = "Configuration updated successfully!";
}

?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Panel</title>
    <style>
        /* Add some basic styling */
    </style>
</head>
<body>
    <h1>Admin Panel</h1>
    <?php if (isset($message)) echo "<p>$message</p>"; ?>
    <form method="post">
        <label for="table_name">Table Name:</label>
        <input type="text" id="table_name" name="table_name" value="<?php echo htmlspecialchars($config['table_name']); ?>" required>
        <br>
        <label for="header_text">Header Text:</label>
        <input type="text" id="header_text" name="header_text" value="<?php echo htmlspecialchars($config['header_text']); ?>" required>
        <br>
        <button type="submit" name="save">Save</button>
    </form>
</body>
</html>
